import os
import torch
import numpy as np

from tqdm import tqdm

np.random.seed(42)

def listdir(*path: str) -> np.ndarray:
    return np.sort(os.listdir(os.path.join(*path)))

def range_time_mapping(data_path: str, org_length: int = 50, min_portion: float = 0.6, max_portion: float = 1) -> None:
    time_dic = {}
    org_taken = np.arange(org_length)
    interval_length = max_portion - min_portion

    for folder_name in tqdm(listdir(data_path)):
        for file_name in listdir(data_path, folder_name):
            time_dic[os.path.join(data_path, folder_name, file_name)] = torch.from_numpy(np.sort(
                np.random.choice(
                    org_taken,
                    size=int(org_length * (min_portion + interval_length * np.random.random())), replace=False
                )
            ))

    np.save('range_time_dic.npy', time_dic)

def delta_time_mapping(data_path: str, org_length: int = 50, min_portion: float = 0.6, max_portion: float = 1) -> None:
    time_dic = {}
    org_taken = np.arange(org_length)
    interval_length = max_portion - min_portion

    for folder_name in tqdm(listdir(data_path)):
        for file_name in listdir(data_path, folder_name):
            range_t = torch.from_numpy(np.sort(
                np.random.choice(
                    org_taken,
                    size=int(org_length * (min_portion + interval_length * np.random.random())), replace=False
                )
            ))
            for i in range(len(range_t) - 1, 0, -1):
                range_t[i] = range_t[i] - range_t[i - 1]
            range_t[0] = 1
            time_dic[os.path.join(data_path, folder_name, file_name)] = range_t

    np.save('delta_time_dic.npy', time_dic)

range_time_mapping('data')
delta_time_mapping('data')